/*
 * 作成日: 2008/08/05
 * 著作権: Copyright (c) 2005 ZIGEN
 * ライセンス：Eclipse Public License - v 1.0
 * 原文：http://www.eclipse.org/legal/epl-v10.html
 */
package zigen.plugin.db.ext.s2jdbc.dto.rule;

import java.sql.Types;

import zigen.plugin.db.core.TableColumn;


public class DefaultDtoMappingFactory extends AbstractDtoMappingFactory {
	
	public String getJavaType(TableColumn column) {
		return getJavaType(column.getDataType());
	}
	
	public String getJavaType(int type) {
		switch (type) {
			case Types.CHAR:
			case Types.VARCHAR:
			case Types.LONGVARCHAR:
				return "String"; //$NON-NLS-1$
				
			case Types.NUMERIC:
			case Types.DECIMAL:
				return "java.math.BigDecimal"; //$NON-NLS-1$
				
			case Types.BIT:
				return "boolean"; //$NON-NLS-1$
				
			case Types.TINYINT:
				return "byte"; //$NON-NLS-1$
				
			case Types.SMALLINT:
				return "short"; //$NON-NLS-1$
				
			case Types.INTEGER:
				return "int"; //$NON-NLS-1$
				
			case Types.BIGINT:
				return "long"; //$NON-NLS-1$
				
			case Types.REAL:
				return "float"; //$NON-NLS-1$
				
			case Types.FLOAT:
			case Types.DOUBLE:
				return "double"; //$NON-NLS-1$
				
			case Types.BINARY:
			case Types.VARBINARY:
			case Types.LONGVARBINARY:
				return "byte[]"; //$NON-NLS-1$
				
			case Types.TIME:
				return "java.sql.Time"; //$NON-NLS-1$
				
			case Types.DATE:
				// return "java.sql.Date"; //$NON-NLS-1$
				return "java.util.Date"; //$NON-NLS-1$
				
			case Types.TIMESTAMP:
				// return "java.sql.Timestamp"; //$NON-NLS-1$
				return "java.util.Date"; //$NON-NLS-1$
				
			case Types.CLOB:
			case Types.BLOB:
			case Types.OTHER:
				return "Object"; //$NON-NLS-1$
				
			default:
				return "<<???>>"; //$NON-NLS-1$
		}
	}
	
	
	public String getTemporalType(int type) {
		switch (type) {
			
			case Types.TIME:
				return "TemporalType.TIME"; //$NON-NLS-1$
				
			case Types.DATE:
				return "TemporalType.DATE"; //$NON-NLS-1$
				
			case Types.TIMESTAMP:
				return "TemporalType.TIMESTAMP"; //$NON-NLS-1$
				
			default:
				return null;
		}
	}
	
	public boolean isLargeObject(int type) {
		switch (type) {
			case Types.LONGVARCHAR:
			case Types.BINARY:
			case Types.VARBINARY:
			case Types.LONGVARBINARY:
			case Types.CLOB:
			case Types.BLOB:
			case Types.OTHER:
				return true;
			default:
				return false;
		}
		
	}
}
